<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\SongRepository;

class SongController extends Controller
{   
    public function __construct(SongRepository $songRepository)
    {
        $this->songRepository = $songRepository;

        $this->perPage = 10;
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $songs = $this->songRepository->getPaginated($this->perPage);

        //dd($songs);
        return view('songs.index', compact('songs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $artists = $this->songRepository->getArtist();
        $albums = $this->songRepository->getAlbum();

        return view('songs.create', compact('artists','albums'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        
        $create = ['song_name_en' => $request->song_name_en,
         'song_name_mm' => $request->song_name_mm,
         'album_id' => $request->album_id,
         'artist_id' => $request->artist_id];
 
        if ($request->is_publish) {
           $create['image'] = $request->is_publish;
        }
        if ($request->is_popular) {
           
            $create['is_popular'] = $request->is_popular;
         }

         if($request->chord_image != null) {
			$image = $request->chord_image;
			$name = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images');
			$image->move($destinationPath, $name);

            $create['chord_image'] = url('/')."/public/images/".$name;
		}

        $this->songRepository->createSong($create);
      
        return redirect()->route('song.index')->with(['status'=>'Created successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $song = $this->songRepository->getById(request()->id);
        $artists = $this->songRepository->getArtist();
        $albums = $this->songRepository->getAlbum();

        return view('songs.detail', compact('song','artists','albums'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $song = $this->songRepository->getById(request()->id);
        $artists = $this->songRepository->getArtist();
        $albums = $this->songRepository->getAlbum();

        return view('songs.edit', compact('song','artists','albums'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
         $request->validate([
            'song_name_en' => 'required',
            'song_name_mm' => 'required',
        ]);
         
        $update = ['song_name_en' => $request->song_name_en,
        'song_name_mm' => $request->song_name_mm,
        'album_id' => $request->album_id,
        'artist_id' => $request->artist_id];

       if ($request->is_publish) {
          $update['image'] = $request->is_publish;
       }
       if ($request->is_popular) {
          
           $update['is_popular'] = $request->is_popular;
        }

        if($request->chord_image != null) {
           $image = $request->chord_image;
           $name = time().'.'.$image->getClientOriginalExtension();
           $destinationPath = public_path('/images');
           $image->move($destinationPath, $name);

           $update['chord_image'] = url('/')."/public/images/".$name;
       }


       $this->songRepository->updateSong($request->id, $update);

       return redirect()->route('song.index')->with(['status'=>'Updated successfully.']);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {

        $this->songRepository->delete($request->id);

        return redirect()->route('song.index')->with(['status'=>'Deleted successfully']);
    }
}
