<?php

namespace App\Http\Controllers\Admin\Township;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\TownshipRepository;
use App\Repositories\Admin\ZoneRepository;

class TownshipController extends Controller
{
    public function __construct(TownshipRepository $townshipRepo, ZoneRepository $zoneRepo)
    {
        $this->townshipRepo = $townshipRepo;
        $this->zoneRepo = $zoneRepo;
        $this->perPage = 15;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $township = $this->townshipRepo->getPaginated($this->perPage);
        return view('townships.index', compact('township'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $zones = $this->zoneRepo->getZone();
        return view('townships.create', compact('zones'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        try {
            $this->townshipRepo->create($data);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        return redirect()->route('township.index')->with(['status'=>'Township was successful added!']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $township = $this->townshipRepo->getById($request->id);
        $zones = $this->zoneRepo->getZone();
        return view('townships.edit', compact('township', 'zones'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = $request->all();
       
        try {
            $this->townshipRepo->update($data, $data['id']);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        
        return redirect()->route('township.index')->with(['status'=>'Township was successful updated!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id=$request->input('id');
        try {
            $zone = $this->townshipRepo->getById($request->id);
            $this->townshipRepo->delete($id);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
    
        return redirect()->route('township.index')->with(['error'=>'Township was successful deleted!']);
    }
    /**
     * Searching by township name
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function search(Request $request)
    {
        $search_data = $request->search_data;
        $township = $this->townshipRepo->filter($request->search_data);
        return view('townships.index', compact('township', 'search_data'));
    }
}
