<?php
namespace App\Repositories\Admin;
use App\Township;

Class TownshipRepository extends BaseRepository
{
    protected $model;

	public function __construct(Township $model)
	{
		$this->model = $model;
	}
	public function getTownship()
    {
        $data=[];
        $township = $this->model->select('id','name')->orderby('id','DESC')->get();
        foreach ($township as $key => $value) {
            $data[$value->id]=$value->name;
        }
        return $data;
    }
    public function filter($data)
    {
        
        return $this->model->where('name','LIKE', '%' .$data. '%')->latest('id')->paginate(15);
        
    }
    
}

?>