@extends('adminlte::page')

@section('content')
            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Update Role</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('role.index')}}">Role List</a>
                            </li>
                            <li class="breadcrumb-item active">
                            <a href="{{url('control-panel/role/edit?id='.$role->id)}}">Update Role</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
               
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <div id="tasks">
                        <!-- The Form to Add a New Task -->

                        {!! Form::open(['route'=>'role.update','method'=>'POST','id'=>'create_role']) !!}
                            {{ csrf_field() }}
                            {{ Form::hidden('id', $role->id) }}
                            <div class="form-group">
                                {{ Form::text('name',$role->name,array('class'=>'form-control','placeholder'=>'Enter Role')) }}
                            </div>
                             @if ($errors->has('name'))
                                    <span class="invalid-feedback">
                                        {{ $errors->first('name') }}
                                    </span>
                            @endif
                            <div class="row"><h4><i class="fas fa-check-circle"></i>Permissions</h4></div>
                            <div class="row">
                                @foreach ($permissions as $key=>$allPermissions)

                                    <?php

                                        $per_found = false;

                                        if( isset($role) ) {

                                            $per_found = $role->hasPermissionTo($allPermissions->name);
                                        }
                                      

                                    ?>

                                    <div class="col-3">
                                        <div class="checkbox">
                                            <label>

                                                {!! Form::checkbox("permission[]", $allPermissions->name, $per_found, isset($options) ? $options : []) !!} {{ $allPermissions->name }}

                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <div class="col-12">
                                <a href="{{route('role.index')}}" class="btn  btn-default">
                                    <i class="fas fa-reply-all"></i> Back
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="far fa-save"></i> Update
                                </button>
                                        
                            </div>
                        {!! Form::close() !!}



                    </div>

                </div>
            </div>
       

@endsection
@section('adminlte_js')
<script>
    jQuery( document ).ready(function( $ ) {

        $('#create_role').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                   
                },
        });

    });
   
</script>
@stop

