@extends('adminlte::page')
@section('content')
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Add Song</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('song.index')}}">Song List</a>
                        </li>
                        <li class="breadcrumb-item active">
                           Add Song
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="card">
            
            {!! Form::open(['route'=>'song.save','method'=>'POST','id'=>'create_township','enctype' => 'multipart/form-data']) !!}
                <div class="card-body">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="artists">Artist</label>
                                    <select class="form-control select2bs4" name="artist_id" required>
                                            <option  value="" >Select Artist</option>
                                        @foreach ($artists as $key => $val)
                                            <option value="{{ $key }}">{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="song_name_en">Song Name EN</label>
                                    <input class="form-control" name="song_name_en" type="text"  required> 
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="albums">Album</label>
                                    <select class="form-control select2bs4" name="album_id" required>
                                            <option  value="" >Select Album</option>
                                        @foreach ($albums as $key => $val)
                                            <option value="{{ $key }}">{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="song_name_mm">Song Name MM</label>
                                    <input class="form-control" name="song_name_mm" type="text"  required> 
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label for="imageInput">Chord Image</label>
                                <div class="form-group">
                                    <input data-preview="#preview" name="chord_image" type="file" id="imageInput" required> 
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="is_popular" value="1">
                                        <label class="form-check-label">Is Popular</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                           
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="is_publish" value="1">
                                        <label class="form-check-label">Is Publish</label>
                                    </div>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-12">
                        <a href="{{route('song.index')}}" class="btn btn-default">
                            <i class="fas fa-reply-all"></i> Back
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="far fa-save"></i> Save
                        </button>
                    </div>
                </div>
            {!! Form::close() !!}
        </div>
    
@endsection
@section('adminlte_js')
<script>
  
    /*For form Validation*/
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop