@extends('adminlte::page')
@section('content')

            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Update Township</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('township.index')}}">Township List</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{url('control-panel/township/edit?id='.$township->id)}}">Update Township</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
              
                {!! Form::open(['route'=>'township.update','method'=>'POST','id'=>'create_township']) !!}
                    {!! Form::hidden('id', $township->id) !!}
                    <div class="card-body">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('name','Township Name',array('class'=>'control-label'))}}
                                        {{ Form::text('name',$township->name,array('class'=>'form-control')) }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('zone_id','Zone',array('class'=>'control-label'))}}
                                        {{ Form::select('zone_id',$zones,$township->zone_id,array('class'=>'form-control select2bs4','placeholder'=>'<--Select Zone-->')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <a href="{{route('township.index')}}" class="btn btn-default">
                                <i class="fas fa-reply-all"></i> Back
                            </a>
                                   
                            <button type="submit" class="btn btn-primary">
                                <i class="far fa-save"></i> Update
                            </button>
                                 
                         
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
            
       
@stop
@section('adminlte_js')
<script>

     /* For Form Validation */
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop