<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


    Route::get('/', function () {
        return redirect()->route('login');
    });

    Route::get('logout', function () {
        auth()->logout();
        Session()->flush();

        return redirect()->route('login');
    })->name('logout');


    Auth::routes();
    Route::get('/home', ['as' => 'control-panel/home', 'uses' => 'HomeController@index']);

    Route::group(['prefix' => 'control-panel', 'middleware' => 'auth'], function () {
        Route::get('/home', ['as' => 'home', 'uses' => 'HomeController@index']);
        Route::group(['prefix' => 'users'], function () {
            Route::get('users', ['as'=>'users.index','uses'=>'UserController@index']);
            Route::get('/create', ['as' => 'users.create' , 'uses' => 'UserController@create']);
            Route::post('save', ['as'=>'users.save','uses'=>'UserController@store']);
            Route::get('/edit', ['as' => 'users.edit' , 'uses' => 'UserController@edit']);
            Route::post('update', ['as'=>'users.update','uses'=>'UserController@update']);
            Route::delete('delete', ['as'=>'users.delete','uses'=>'UserController@destroy']);
        });
       
        Route::group(['prefix' => 'permission'], function () {
            Route::get('/permission', ['as' => 'permission.index' , 'uses' => 'PermissionController@index']);
            Route::post('/save', ['as' => 'permission.save', 'uses' => 'PermissionController@store']);
            Route::patch('/update', ['as' => 'permission.update', 'uses' => 'PermissionController@update']);
            Route::delete('/delete', ['as' => 'permission.delete', 'uses' => 'PermissionController@destroy']);
        });
        Route::group(['prefix' => 'role'], function () {
            Route::get('/role', ['as' => 'role.index' , 'uses' => 'RoleController@index']);
            Route::get('/create', ['as' => 'role.create' , 'uses' => 'RoleController@create']);
            Route::post('/save', ['as' => 'role.save' , 'uses' => 'RoleController@store']);
            Route::get('/edit', ['as' => 'role.edit' , 'uses' => 'RoleController@edit']);
            Route::post('/update', ['as' => 'role.update' , 'uses' => 'RoleController@update']);
            Route::delete('/delete', ['as' => 'role.delete', 'uses' => 'RoleController@destroy']);
        });

        // Route::group(['prefix' => 'zone','namespace' => 'Admin\Zone'], function () {
        //     Route::get('zone', ['as' => 'zone.index' ,'uses' => 'ZoneController@index']);
        //     Route::get('create', ['as' => 'zone.create','uses'=>'ZoneController@create']);
        //     Route::post('save', ['as' => 'zone.save' ,'uses'=>'ZoneController@store']);
        //     Route::get('status/change', ['as' => 'zone.status.change' , 'uses' => 'ZoneController@statusChange']);
        //     Route::get('edit', ['as' => 'zone.edit','uses' => 'ZoneController@edit']);
        //     Route::post('update', ['as' => 'zone.update','uses' => 'ZoneController@update']);
        //     Route::delete('/delete', ['as' => 'zone.delete', 'uses' => 'ZoneController@destroy']);
        //     Route::get('/search', ['as' => 'zone.search' ,'uses' => 'ZoneController@search']);
        // });
        Route::group(['prefix' => 'township','namespace' => 'Admin\Township'], function () {
            Route::get('township', ['as'=>'township.index','uses' => 'TownshipController@index']);
            Route::get('create', ['as' => 'township.create','uses'=>'TownshipController@create']);
            Route::post('save', ['as' => 'township.save','uses'=>'TownshipController@store']);
            Route::get('edit', ['as' => 'township.edit' ,'uses' => 'TownshipController@edit']);
            Route::post('update', ['as' => 'township.update','uses' => 'TownshipController@update']);
            Route::delete('/delete', ['as' => 'township.delete','uses' => 'TownshipController@destroy']);
            Route::get('/search', ['as' => 'township.search' ,'uses' => 'TownshipController@search']);
        });
        // Route::group(['prefix' => 'hotel' , 'namespace' => 'Admin\Hotel'], function () {
        //     Route::get('hotel_info', ['as'=>'hotel.info.index','uses' => 'Hotel_InformationController@index']);
        //     Route::get('create', ['as'=>'hotel.info.create','uses'=>'Hotel_InformationController@create']);
        //     Route::post('save', ['as' => 'hotel.info.save','uses'=>'Hotel_InformationController@store']);
        //     Route::get('edit', ['as' => 'hotel.info.edit' ,'uses' => 'Hotel_InformationController@edit']);
        //     Route::post('update', ['as' => 'hotel.info.update','uses' => 'Hotel_InformationController@update']);
        //     Route::delete('/delete', ['as' => 'hotel.info.delete','uses' => 'Hotel_InformationController@destroy']);
        //     Route::get('/search', ['as' => 'hotel.info.search' ,'uses' => 'Hotel_InformationController@search']);
        // });

      

        Route::group(['prefix' => 'artist','namespace' => 'Admin'], function () {
            Route::get('artist', ['as'=>'artist.index','uses' => 'ArtistController@index']);
            Route::get('create', ['as' => 'artist.create','uses'=>'ArtistController@create']);
            Route::post('/save', ['as' => 'artist.save','uses'=>'ArtistController@store']);
            Route::get('edit', ['as' => 'artist.edit','uses' => 'ArtistController@edit']);
            Route::post('artist', ['as' => 'artist.update','uses' => 'ArtistController@update']);
            Route::delete('/delete', ['as' => 'artist.delete','uses' => 'ArtistController@destroy']);
            Route::get('/search', ['as' => 'artist.search' ,'uses' => 'ArtistController@search']);
        });

        Route::group(['prefix' => 'album','namespace' => 'Admin'], function () {
            Route::get('album', ['as'=>'album.index','uses' => 'AlbumController@index']);
            Route::get('create', ['as' => 'album.create','uses'=>'AlbumController@create']);
            Route::post('/save', ['as' => 'album.save','uses'=>'AlbumController@store']);
            Route::get('edit', ['as' => 'album.edit' ,'uses' => 'AlbumController@edit']);
            Route::post('album', ['as' => 'album.update','uses' => 'AlbumController@update']);
            Route::delete('/delete', ['as' => 'album.delete','uses' => 'AlbumController@destroy']);
            Route::get('/search', ['as' => 'album.search' ,'uses' => 'AlbumController@search']);
        });

        // Route::group(['prefix' => 'music','namespace' => 'Admin'], function () {
        //     Route::get('music', ['as'=>'music.index','uses' => 'MusicController@index']);
        //     Route::get('create', ['as' => 'music.create','uses'=>'MusicController@create']);
        //     Route::post('music', ['as' => 'music.save','uses'=>'MusicController@store']);
        //     Route::get('edit', ['as' => 'music.edit','uses' => 'MusicController@edit']);
        //     Route::put('music', ['as' => 'music.update','uses' => 'MusicController@update']);
        //     Route::delete('music', ['as' => 'music.delete','uses' => 'MusicController@destroy']);
        //     Route::get('/search', ['as' => 'music.search' ,'uses' => 'MusicController@search']);
        // });

        Route::group(['prefix' => 'image','namespace' => 'Admin'], function () {
            Route::get('image', ['as'=>'image.index','uses' => 'ImageController@index']);
            Route::get('create', ['as' => 'image.create','uses'=>'ImageController@create']);
            Route::post('image', ['as' => 'image.save','uses'=>'ImageController@store']);
            Route::get('edit', ['as' => 'image.edit','uses' => 'ImageController@edit']);
            Route::put('image', ['as' => 'image.update','uses' => 'ImageController@update']);
            Route::delete('image', ['as' => 'image.delete','uses' => 'ImageController@destroy']);
            Route::get('/search', ['as' => 'image.search' ,'uses' => 'ImageController@search']);
        });


        Route::group(['prefix' => 'song','namespace' => 'Admin'], function () {
            Route::get('song', ['as'=>'song.index','uses' => 'SongController@index']);
            Route::get('create', ['as' => 'song.create','uses'=>'SongController@create']);
            Route::post('save', ['as' => 'song.save','uses'=>'SongController@store']);
            Route::get('edit', ['as' => 'song.edit','uses' => 'SongController@edit']);
            Route::get('detail', ['as' => 'song.detail','uses' => 'SongController@show']);
            Route::post('song', ['as' => 'song.update','uses' => 'SongController@update']);
            Route::delete('song', ['as' => 'song.delete','uses' => 'SongController@destroy']);
            Route::get('/search', ['as' => 'song.search' ,'uses' => 'SongController@search']);
        });



    });
