<?php $__env->startSection('content'); ?>
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Add Album</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="<?php echo e(route('album.index')); ?>">Album List</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="<?php echo e(route('album.create')); ?>">Add Album</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="card">
            
            <!-- The Form to Add a New Album -->
            <?php echo Form::open(['route'=>'album.save','method'=>'POST','id'=>'create_album','enctype' => 'multipart/form-data']); ?>

                <div class="card-body">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="artists">Artist</label>
                                    <select class="form-control select2bs4" name="artist_id" required>
                                            <option  value="" >Select Artist</option>
                                        <?php $__currentLoopData = $artists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($val); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="album_name_en">Album Name EN</label>
                                    <input class="form-control" name="album_name_en" type="text"  required> 
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="album_name_mm">Album Name MM</label>
                                    <input class="form-control" name="album_name_mm" type="text"  required> 
                                </div>
                            </div>
                            <div class="col-6">
                                <label for="imageInput">Album Image</label>
                                <div class="form-group">
                                    <input data-preview="#preview" name="album_image" type="file" id="imageInput" required> 
                                </div>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-12">
                        <a href="<?php echo e(route('album.index')); ?>" class="btn btn-default">
                            <i class="fas fa-reply-all"></i> Back
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="far fa-save"></i> Save
                        </button>
                    </div>
                </div>
            <?php echo Form::close(); ?>

        </div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('adminlte_js'); ?>
<script>
  
    /*For form Validation*/
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\music-app\resources\views/albums/create.blade.php ENDPATH**/ ?>