<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\ArtistRepository;

class ArtistController extends Controller
{   
    public function __construct(ArtistRepository $artistRepository)
    {
        $this->artistRepository = $artistRepository;
        $this->perPage = 10;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $artists = $this->artistRepository->getPaginated($this->perPage);
        
        return view('artists.index', compact('artists'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('artists.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $this->artistRepository->createArtist($request->all());
      
        return redirect()->route('artist.index')->with(['status'=>'Created successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {

        $artist = $this->artistRepository->getById(request()->id);

        return view('artists.edit', compact('artist'));


    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        
        // dd($request->all());

        $request->validate([
            'name_en' => 'required',
            'name_mm' => 'required',
            'gender' => 'required',
        ]);
         
        $update = ['name_en' => $request->name_en, 'name_mm' => $request->name_mm, 'gender' => $request->gender];
 
        if ($files = $request->file('image')) {
           $destinationPath = 'public/images/'; // upload path
           $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
           $files->move($destinationPath, $profileImage);
           $update['image'] = url('/')."/public/images/"."$profileImage";
        }
        if ($files = $request->file('cover_image')) {
            $destinationPath = 'public/images/'; // upload path
            $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
            $files->move($destinationPath, $profileImage);
            $update['cover_image'] = url('/')."/public/images/"."$profileImage";
         }

       $this->artistRepository->updateArtist($request->id, $update);
            
        
        return redirect()->route('artist.index')->with(['status'=>'Updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $this->artistRepository->delete($request->id);

        return redirect()->route('artist.index')->with(['status'=>'Deleted successfully']);
    }
}
