<?php

namespace App\Http\Controllers\Admin\Hotel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\Hotel_InformationRepository;
use App\Repositories\Admin\TownshipRepository;

class Hotel_InformationController extends Controller
{
    public function __construct(Hotel_InformationRepository $hotelInfoRepo, TownshipRepository $townshipRepo)
    {
        $this->hotelInfoRepo = $hotelInfoRepo;
        $this->townshipRepo = $townshipRepo;
        $this->perPage = 15;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $hotelinfos = $this->hotelInfoRepo->getPaginated($this->perPage);
        return view('hotel_infos.index', compact('hotelinfos'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $townships = $this->townshipRepo->getTownship();
        return view('hotel_infos.create', compact('townships'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        try {
            $this->hotelInfoRepo->create($data);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
       
        return redirect()->route('hotel.info.index')->with(['status'=>'Hotel Information was successful added!']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $hotelinfos = $this->hotelInfoRepo->getById($request->id);
        $townships = $this->townshipRepo->getTownship();
        return view('hotel_infos.edit', compact('hotelinfos', 'townships'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = $request->all();
        try {
            $this->hotelInfoRepo->update($data, $data['id']);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        
        return redirect()->route('hotel.info.index')->with(['status'=>'Hotel Information was successful updated!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     *  @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id=$request->input('id');
        try {
            $zone = $this->hotelInfoRepo->getById($request->id);
            $this->hotelInfoRepo->delete($id);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        return redirect()->route('hotel.info.index')->with(['error'=>'Hotel Information was successful deleted!']);
    }

    /**
     * Searching by hotel name
     * @param \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function search(Request $request)
    {
        $search_data = $request->search_data;
        $hotelinfos = $this->hotelInfoRepo->filter($request->search_data);
        return view('hotel_infos.index', compact('hotelinfos', 'search_data'));
    }
}
