<?php
namespace App\Repositories\Admin;
use App\Album;
use App\Artist;

Class AlbumRepository extends BaseRepository
{
    protected $model;

	public function __construct(Album $model)
	{
		$this->model = $model;
	}
	public function createAlbum($data)
    {

		if($data['album_image']!= null) {
			$image = $data['album_image'];
			$name = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images');
			$image->move($destinationPath, $name);

			$image_url = url('/')."/public/images/".$name;
		}

		
		return $this->model->create(['album_name_en'=>$data['album_name_en'],'album_name_mm'=>$data['album_name_mm'],'artist_id'=>$data['artist_id'],
		'album_image'=>$image_url]);
	}
	public function getArtist()
    {
        $data=[];
        $artists = Artist::select('id','name_en')->orderby('id','DESC')->get();
        foreach ($artists as $key => $value) {
            $data[$value->id]=$value->name_en;
        }
        return $data;
	}

	public function updateAlbum($id,$data)
    {

    	return $this->model->where('id',$id)->update($data);

    }
    
}

?>
