<?php
namespace App\Repositories\Admin;
use App\Artist;

Class ArtistRepository extends BaseRepository
{
    protected $model;

	public function __construct(Artist $model)
	{
		$this->model = $model;
	}
	
	public function createArtist($data)
    {
		// dd($data);
		if($data['image']!= null) {
			$image = $data['image'];
			$name = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images');
			$image->move($destinationPath, $name);

			$image_url = url('/')."/public/images/".$name;
		}
		if($data['cover_image']!= null){

			$image = $data['cover_image'];
			$name = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images');
			$image->move($destinationPath, $name);
			$cover_image_url = url('/')."/public/images/".$name;		
		}
		
		return $this->model->create(['name_en'=>$data['name_en'],'name_mm'=>$data['name_mm'],
		'gender'=>$data['gender'],'image'=>$image_url,'cover_image'=>$cover_image_url]);
	}
	
	public function updateArtist($id,$data)
    {

    	return $this->model->where('id',$id)->update($data);

    }
}

?>
