<?php
namespace App\Repositories\Admin;
use App\Zone;

Class ZoneRepository extends BaseRepository
{
    protected $model;

	public function __construct(Zone $model)
	{
		$this->model = $model;
	}
	public function statusChange($status,$id)
	{
		$model = $this->getById($id);
		$model['fetch_status'] = $status;
		return $model->push();
	}

	public function getZone()
    {
        $data=[];
        $zones = $this->model->where('fetch_status',1)->select('id','zone_name')->orderby('id','DESC')->get();
        foreach ($zones as $key => $value) {
            $data[$value->id]=$value->zone_name;
        }
        return $data;
	}
	
	public function filter($data)
    {
        
        return $this->model->where('zone_name','LIKE', '%' .$data. '%')->latest('id')->paginate(15);
        
    }

    
}

?>
