<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Song extends Model
{
    protected $table = 'songs';

    protected $fillable = ['song_name_en','song_name_mm','chord_image','artist_id','album_id','is_popular','is_publish'];

    public function artist()
    {
        return $this->belongsTo('App\Artist', 'artist_id');

    }
    public function album()
    {
        return $this->belongsTo('App\Album', 'album_id');

    }
}


