<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Township extends Model
{
    protected $table = 'townships';
    protected $fillable = ['zone_id','name'];
    protected $hidden = ['id'];
   
    public function hotel_info()
    {
        return $this->hasMany('App\Hotel_Information', 'township_id');
    }
    
    public function zone()
    {
        return $this->belongsTo('App\Zone');
    }
}
