<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSongsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('songs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('song_name_en');
            $table->text('song_name_mm');
            $table->boolean('is_popular')->nullable();
            $table->boolean('is_publish')->nullable();
            $table->unsignedBigInteger('artist_id');
            $table->timestamps();

            $table->foreign('artist_id')->references('id')->on('artists'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('songs');
    }
}
