@extends('adminlte::page')
@section('content')
    <div class="content-header">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="text-dark">Artist List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="#">Home</a>
                    </li>
                    <li class="breadcrumb-item active">
                        <a href="{{ route('artist.index') }}">Artist List</a>
                    </li>
                </ol>
            </div>
        </div>
    </div>
    @if (session('status'))
        <div class="alert alert-success" role="alert" id="dialog">
            {{ session('status') }}
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger" role="alert" id="errordialog">
            {{ session('error') }}
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="col-12">
                <div class="row">

                    <div class="col-8">
                        <div class="row">
                            <div class="col-2">
                                {!! Form::label('search_data', 'Artist Name', ['class' => 'label-control']) !!}
                            </div>
                            <div class="col-5">
                                {!! Form::open(['route' => 'artist.search', 'method' => 'GET']) !!}
                                @include('filters.filter')
                                {!! Form::close() !!}
                            </div>
                        </div>

                    </div>
                    <div class="col-4">
                        <a href="{{ route('artist.create') }}">

                            <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle"
                                    aria-hidden="true"></i>&nbsp;&nbsp;Add Artist</button>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">

            <!-- The List of Township -->

            <div>

                @if (isset($artists))
                    <table class="table table-striped table-bordered task-table">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Name EM</th>
                                <th>Name MM</th>
                                <th>Gender</th>
                                <th>Profile Image</th>
                                <th>Cover Image</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($artists as $key => $item)

                                <tr>
                                    <td>{{ $artists->firstItem() + $key }}</td>
                                    <td>{{ $item->name_en }}</td>
                                    <td>{{ $item->name_mm }}</td>
                                    <td>{{ $item->gender }}</td>
                                    <td> <img class="img-circle img-md" src="{{$item->image}}"></td>
                                    <td> <img class="img-circle img-md" src="{{$item->cover_image}}"></td>

                                    <td>
                                        <div class="row">

                                            {{ Form::open(['route' => 'artist.edit', 'method' => 'get']) }}
                                            {{ Form::hidden('id', $item->id) }}
                                            <button type="submit" class="btn btn-warning btn-sm action-btn"><i
                                                    class="fas fa-pencil-alt"></i> </button>
                                            {{ Form::close() }}

                                            
                                            <button data-toggle="modal" data-target="#deleteModal" data-id="{{ $item->id }}"
                                                class="btn btn-danger btn-sm action-btn">
                                                <i class="fa fa-trash"></i>

                                            </button>
                                        </div>

                                    </td>
                                </tr>

                            @endforeach
                        </tbody>

                    </table>
                    <div style="float: right;">
                        {!! Form::open(['route' => 'artist.delete', 'method' => 'delete', 'id' => 'delete_form']) !!}
                        {{ Form::hidden('id', 0) }}
                        {!! Form::close() !!}
                        {{ $artists->appends(['search_data' => 'search_data'])->links() }} <!-- for paginate link -->
                    </div>

                @endif


            </div>

        </div>

    </div>
    </div>

    <div id="deleteModal" class="modal fade">
        <div class="modal-dialog modal-confirm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Are you sure?</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">
                    <p>Do you really want to delete this record?</p>
                    <form action="{{route('artist.delete')}}" method="post">
                        {{method_field('DELETE')}}                       
                        @csrf
                        <input type="hidden" name="id" id="delete_id" value="">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('adminlte_js')
<script>
 $('#deleteModal').on('show.bs.modal', function (e) {
    var button = $(e.relatedTarget);
    // console.log('ok');
    var id = button.data('id');
  
    // alert(id);
    modal = $(this);
    modal.find('.modal-body #delete_id').val(id);
  
  
});
</script>
@stop
