@extends('adminlte::page')
@section('content')

        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Update Hotel Information</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('hotel.info.index')}}">Hotel Information List</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{url('control-panel/hotel/edit?id='.$hotelinfos->id)}}">Update Hotel Information</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="card">
           
            {!! Form::open(['route'=>'hotel.info.update','method'=>'POST','id'=>'create_hotel_info']) !!}
                {!! Form::hidden('id', $hotelinfos->id) !!}
                <div class="card-body">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('township_id','Township',array('class'=>'control-label'))}}
                                    {{ Form::select('township_id',$townships,$hotelinfos->township_id,array('class'=>'form-control select2bs4','placeholder'=>'<--Select Township-->')) }}
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('name','Hotel Name',array('class'=>'control-label'))}}
                                    {{ Form::text('name',$hotelinfos->name,array('class'=>'form-control')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('license','License',array('class'=>'control-label'))}}
                                    {{ Form::text('license',$hotelinfos->license,array('class'=>'form-control')) }}
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('rooms','Rooms',array('class'=>'control-label'))}}
                                    {{ Form::text('rooms',$hotelinfos->rooms,array('class'=>'form-control')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('address','Address',array('class'=>'control-label'))}}
                                    {{ Form::textarea('address',$hotelinfos->address,array('class' =>'form-control')) }}
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    {{ Form::label('contact','Contact',array('class'=>'control-label'))}}
                                    {{ Form::text('contact',$hotelinfos->contact,array('class'=>'form-control')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <a href="{{route('hotel.info.index')}}" class="btn btn-default back-btn">
                            <i class="fas fa-reply-all"></i> Back
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="far fa-save"></i> Update
                        </button>
                    </div>
                </div>
            {!! Form::close() !!}
        </div>
   

@endsection
@section('adminlte_js')
<script>
    /* For Form Validation */
    jQuery( document ).ready(function( $ ) {

        $('#create_hotel_info').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    township_id: {
                        required: true,
                    },
                    name:{
                        required: true,
                    },
                    license:{
                        required: true,
                    },
                    rooms:{
                        required: true,
                    },
                    address:{
                        required: true,
                    },
                    contact:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop