@extends('adminlte::page')
@section('plugins.Sweetalert2', true)
@section('content')
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">User List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('users.index')}}">User List</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        @if (session('status'))
                <div class="alert alert-success" role="alert" id="dialog">
                    {{ session('status') }}
                </div>
        @endif
        @if (session('error'))
                <div class="alert alert-danger" role="alert" id="errordialog">
                    {{ session('error') }}
                </div>
        @endif
        <div class="card">
                <div class="card-header">
                  
                    @can('create_user')
                        <a href="{{route('users.create')}}">

                            <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add User</button>
                        </a>
                    @endcan
                </div>

                <div class="card-body">

                        <!-- The List of Users -->


                                @if(isset($users))
                                <table class="table table-striped table-bordered task-table">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Name</th>
                                            <th>Role</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($users as $key=>$item)
                                        <tr>
                                            <td>{{$users->firstItem()+$key}}</td>
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->role['name']}}</td>
                                            <td>
                                                <div class="row">
                                                    @can('edit_user')
                                                        {!! Form::open(['route'=>'users.edit','method'=>'get']) !!}
                                                            {{ Form::hidden('id',$item->id) }}
                                                            <button class="btn btn-info btn-sm action-btn"><i class="fas fa-pencil-alt"></i>Edit</button>

                                                        {!! Form::close() !!}
                                                    @endcan
                                                    @can('delete_user')
                                                    <button
                                                        data-toggle="modal" data-target="#deleteModal"
                                                        data-id="{{ $item->id }}"
                                                            
                                                        class="btn btn-danger btn-sm action-btn">
                                                        <i class="fa fa-trash"> Delete</i>

                                                    </button>
                                                    @endcan
                                                </div>
                                                
                                            </td>
                                            @include('layouts.delete',['id' => $item->id,'route'=>'users.delete'])
                                        </tr>

                                        @endforeach
                                    </tbody>
                                </table>
                                <div style="float: right;">
                                    {!! Form::open(['route'=>'users.delete','method'=>'delete','id'=>'delete_form']) !!}			
			                                {{ Form::hidden('id',0) }}
		                            {!! Form::close() !!}
                                    {{ $users->links() }} <!-- for paginate link -->
                                </div>

                                @endif
                    </div>

                </div>
            </div>
@endsection
