<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="text-dark">Album List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="#">Home</a>
                    </li>
                    <li class="breadcrumb-item active">
                        <a href="<?php echo e(route('album.index')); ?>">Album List</a>
                    </li>
                </ol>
            </div>
        </div>
    </div>
    <?php if(session('status')): ?>
        <div class="alert alert-success" role="alert" id="dialog">
            <?php echo e(session('status')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger" role="alert" id="errordialog">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <div class="col-12">
                <div class="row">

                    <div class="col-8">
                        <div class="row">
                            <div class="col-2">
                                <?php echo Form::label('search_data', 'Album Name', ['class' => 'label-control']); ?>

                            </div>
                            <div class="col-5">
                                <?php echo Form::open(['route' => 'album.search', 'method' => 'GET']); ?>

                                <?php echo $__env->make('filters.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>

                    </div>
                    <div class="col-4">
                        <a href="<?php echo e(route('album.create')); ?>">

                            <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle"
                                    aria-hidden="true"></i>&nbsp;&nbsp;Add Album</button>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">


            <div>

                <?php if(isset($albums)): ?>
                    <table class="table table-striped table-bordered task-table">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Artist Name</th>
                                <th>Album Name EN</th>
                                <th>Album Name MM</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td><?php echo e($albums->firstItem() + $key); ?></td>
                                    <td><?php echo e($item->artist->name_en); ?></td>
                                    <td><?php echo e($item->album_name_en); ?></td>
                                    <td><?php echo e($item->album_name_mm); ?></td>

                                    <td>
                                        <div class="row">

                                            <?php echo e(Form::open(['route' => 'album.edit', 'method' => 'get'])); ?>

                                            <?php echo e(Form::hidden('id', $item->id)); ?>

                                            <button type="submit" class="btn btn-warning btn-sm action-btn"><i
                                                    class="fas fa-pencil-alt"></i></button>
                                            <?php echo e(Form::close()); ?>



                                            <button data-toggle="modal" data-target="#deleteModal" data-id="<?php echo e($item->id); ?>"
                                                class="btn btn-danger btn-sm action-btn">
                                                <i class="fa fa-trash"></i>

                                            </button>
                                        </div>

                                    </td>
                                    <?php echo $__env->make('layouts.delete',['id' => $item->id,'route'=>'album.delete'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                    <div style="float: right;">
                        <?php echo Form::open(['route' => 'album.delete', 'method' => 'delete', 'id' => 'delete_form']); ?>

                        <?php echo e(Form::hidden('id', 0)); ?>

                        <?php echo Form::close(); ?>

                        <?php echo e($albums->appends(['search_data' => 'search_data'])->links()); ?> <!-- for paginate link -->
                    </div>

                <?php endif; ?>


            </div>

        </div>

    </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('adminlte_js'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\music-app\resources\views/albums/index.blade.php ENDPATH**/ ?>